# FILE: OKeyParser.py
#
# OKeyParser - xml paresr module
#
# parse xml dictionary for the "Neuroinfo" ontology
#
# (C) 2003-2004 by CC Open Computer Systems for the "Neuroinfo" project
# This is free software avaiable under the GPL license, see:
#   LICENSE.txt, README.txt for details.
# ==================================================================
"""
Borrowed from wxPython XML tree demo and modified.
"""

import string
import os
import Shared.DC.xml.pyexpat.pyexpat as expat


# GB - Quick and dirty XML parser
# GB - we keep the parse state in flag variables: XML_in_...
# GB - the parser bulds a simple dictionary of search terms extracted from the
class OntologyXmlParser:
    'A parsed XML element'
    def  __init__(self):
        self.XML_in_vocabulary=0
        
        self.XML_in_relations=0
        self.XML_in_relation=0
        
        self.XML_in_keywords=0
        self.XML_in_keyword=0
        self.XML_in_reference=0

        self.relations = {}
        self.keywords = {}
        self.owl = {}

        self.active = None
        
                       
        
        
    def StartElement(self, name, attributes):
        ''''SAX start element even handler'''
        if name == 'vocabulary' and not self.XML_in_vocabulary:
            self.XML_in_vocabulary = 1
            

        # relation
        elif name == 'relations' and self.XML_in_vocabulary and not self.XML_in_keyword and not self.XML_in_relations:
            self.XML_in_relations  = 1
        elif name == 'relation' and self.XML_in_relations and not  self.XML_in_relation:
            self.XML_in_relation = 1
            self.relations[attributes[1]] = attributes[3]
            
                
        # keywords
        elif name == 'keywords' and self.XML_in_vocabulary and not self.XML_in_relations and not  self.XML_in_keywords:
            self.XML_in_keywords = 1
        elif name == 'keyword' and self.XML_in_keywords and not self.XML_in_keyword:
            self.XML_in_keyword = 1
            self.active = attributes[1]
            self.keywords[attributes[1]] = attributes[3]
        elif name == 'reference' and self.XML_in_keyword and not self.XML_in_reference:
            dict = {}
            tmp = []
            self.XML_in_reference = 1
            if self.owl.has_key(self.active):
                dict = self.owl[self.active]
            
            if dict.has_key(attributes[3]):
                tmp = dict[attributes[3]]
            
            tmp.append(attributes[1])
            dict[attributes[3]] = tmp
            self.owl[self.active] = dict
            
        
        
        
    def EndElement(self,name):
        '''SAX end element event handler'''
        if name == 'vocabulary' and self.XML_in_vocabulary:
            self.XML_in_vocabulary = 0
            self.XML_in_relations  = 0
            self.XML_in_relation   = 0
            self.XML_in_keywords   = 0
            self.XML_in_keyword    = 0
            self.XML_in_reference  = 0
        
        # relation
        elif name == 'relations':
            self.XML_in_relations  = 0
        elif name == 'relation':
            self.XML_in_relation   = 0
        
        # keywords
        elif name == 'keywords':
            self.XML_in_keywords   = 0
            self.active = None
        elif name == 'keyword':
            self.XML_in_keyword    = 0
        elif name == 'reference':
            self.XML_in_reference  = 0

    
    
    
    def CharacterData(self,data):
        '''SAX character data event handler'''
        pass

    
    
    
    def Parse(self,body):
        '''Expat parset settings'''
        Parser = expat.ParserCreate()

        # SAX event handlers
        Parser.StartElementHandler = self.StartElement
        Parser.EndElementHandler = self.EndElement
        Parser.CharacterDataHandler = self.CharacterData

        # Parse the XML File
        ParserStatus = Parser.Parse(body)
        
        return self.relations, self.keywords, self.owl





def ReadFile( filename ):
    body = ''
    file = None
    try:
        file = open( filename, "r" )
        body = file.read()
    finally:
        if file:
            file.close()
            
    return body;




class ParseXmlOKey:
    def ParseXmlOKey(self):
        '''Ontology parser'''
        body = ReadFile('/opt/plone/Products/OntologyKeys/keywords.xml')
        parser = OntologyXmlParser()
        ret_dict = parser.Parse(body)
    
        return ret_dict
    
