# FILE: OWL.py
#
# OWL - Ontology Keys core module
#
# dictionary search module
#
# (C) 2003-2004 by CC Open Computer Systems for the "Neuroinfo" project
# This is free software avaiable under the GPL license, see:
#   LICENSE.txt, README.txt for details.
# ==================================================================
from OKeyParser import ParseXmlOKey


OwlRelations = {}
OwlKeys = {}
Ontology = {}
    


def OWLinit():
  global OwlRelations
  global OwlKeys
  global Ontology
  
  owl = ParseXmlOKey()
  [OwlRelations, OwlKeys, Ontology] = owl.ParseXmlOKey() 
  
  

#Here I include the subclasses of my OWL product
#See the import comments to know what does each class
class OWL:
  """OWL class definition"""

  global OwlRelations
  global OwlKeys
  global Ontology
  
  
  def getKeyName( self, key='' ):
    """ full list Ontology """
    return OwlKeys.get(key)

  def getOwlRelationsList(self):
    """ full list Ontology relatins """
    return OwlRelations
    
  def getRelationScore( self, key='' ):
    """ full list Ontology """
    return OwlRelations.get(key)

  def getRelatedTo(self, key='', relation='' ):
    """ related of """
    res = []
    if Ontology.has_key(key):
      tmp = Ontology[key]
      if tmp.has_key(relation):
        res = tmp[relation]
    return res

  def getOwlKey(self, key=''):
    """ related of """
    if Ontology.has_key(key):
      return Ontology[key]
    return None
  
  def getOwlList(self):
    """ full list Ontology """
    return OwlKeys

  
  
  def searchOwlKeys(self, pattern='', count=5, step=0, search_type=0 ):
    """ search keywords """
    res = []
    
    try:
      step=int(step)
    except:
      step=0
    
    try:
      count=int(count)
    except:
      count=5
    
    try:
      search_type=int(search_type)
    except:
      search_type=0
    
    if pattern == None:
      return 0, res
    
    if search_type == 1:
      if Ontology.has_key(pattern):
        res.append(pattern)
      return len(res), res
    
    for i in OwlKeys:
      if pattern in OwlKeys.get(i):
        res.append(i)
    return len(res), res[(step*count):((step+1)*count)]

    
    
