## Script (Python) "SE_queryCatalog"
##bind container=container
##bind context=context
##bind namespace=
##bind script=script
##bind subpath=traverse_subpath
##parameters=
##title=
##
# FILE: SE_queryCatalog.py
#
# SE_queryCatalog - Search External server module
#
# Parse xml soap query and construct query for ZCatalog.
# Return N results only.
#
# (C) 2003 by CC Open Computer Systems for the "Neuroinfo" project
# This is free software avaiable under the GPL license, see:
#   LICENSE.txt, README.txt for details.
# ==================================================================

N=10
results=[]
REQUEST=context.REQUEST
catalog=context.portal_catalog
indexes=catalog.indexes()
soap_query={}
query={}

translate_tab = {
  'QueryType'      : 'portal_type',
  'datebeg'        : 'created',
  'SearchableText' : 'SearchableText',
  
  'dc:type'        : 'portal_type',
  'dc:created'     : 'created',
  'dc:title'       : 'Title',
  'dc:description' : 'Description',
  'dc:creator'     : 'Creator',
  'dc:subject'     : 'Subject', 
}

body = REQUEST.get('BODY')
soap_query = context.soap_tool.ParseSoapMessage(body)

query['review_state'] = 'published'
query['created_usage'] = 'range:min'

# ==================================================================
# translate to query
# ==================================================================
for i in soap_query.keys():
  if translate_tab.has_key(i):
    if query.has_key(translate_tab[i]):
      tmp = query[translate_tab[i]]
      query[translate_tab[i]] = tmp + ';' + soap_query[i]
    else:
      query[translate_tab[i]] = soap_query[i]


# ==================================================================
# translate 'query list' to list
# ==================================================================
if query.has_key('Subject'):
  query['Subject'] = query['Subject'].split(';')
  

# ==================================================================
# query catalog
# ==================================================================
if query:
  results=catalog(query)

if len(results) > N:
  results = results[:N]

return results
