function [votes Y_pred]=LCMC_ensemble_classify(ensemble,A,classes,levels,noreg)
    [l C N]=size(A);
    T=length(ensemble);

    votes=zeros(l,length(classes));   
        
    for t=1:T
        positive=ensemble{t}.positive;
        negative=setdiff(classes,ensemble{t}.positive);                               

	A_d=LIFT_prepare_levels(levels,squeeze(A(:,ensemble{t}.channel,:)));

	if(noreg)
          [d_trn i]=classify_with_local_classifiers_noreg(A_d,levels,ensemble{t}.W);
	else 
	  [d_trn i]=classify_with_local_classifiers_reg(A_d,levels,ensemble{t}.W);
	end
        d_trn=d_trn(:,i(1)+1:end);
        y=d_trn(:,ensemble{t}.best);
 
	
        votes(y>0,positive)=votes(y>0,positive)+ensemble{t}.weight;
        votes(y<=0,negative)=votes(y<=0,negative)+ensemble{t}.weight;
    end
    
    [s i]=max(votes');    
    Y_pred=classes(i');