function [err_tst err_trn]=LC_PSVM_VOTED_CVK(A,Y,K,nu,levels,L,T)
    folds=crossvalind('Kfold',Y,K);
    err_tst=zeros(K,1);
    err_trn=zeros(K,1);    

    for k=1:K
        test = (folds==k); train = ~test;
        A_trn=LIFT_prepare_levels(levels,A(train,:));
        A_tst=LIFT_prepare_levels(levels,A(test,:));

        [W i]=build_local_classifiers_reg(A_trn,diag(Y(train)),L,nu);
        d_trn=classify_with_local_classifiers_reg(A_trn,levels,W);
        d_tst=classify_with_local_classifiers_reg(A_tst,levels,W);
        
        d_trn=2*(d_trn>0)-1;
        d_tst=2*(d_tst>0)-1;        
        
        d_trn=sum(d_trn')';
        d_tst=sum(d_tst')';
        
        err_trn(k)=mean(Y(train).*d_trn <= 0);
        err_tst(k)=mean(Y(test).*d_tst <= 0);
    end