function S=LC_calc_similarity_matrix(A,T,level, k, L)
    num_of_objects=rows(A);  
    num_of_classes=2;
    S=zeros(num_of_objects, num_of_objects);   
        
    %Two classes:
    %  1 - original data we want to analyse
    % -1 - randomised version of the data
    Y=diag(PSVM_D(num_of_objects,num_of_objects));
%    Y=(Y+1)/2+1;
           
    %Create randomized version of matrix A
    A=[A; A];
    for a=1:columns(A)
%        A(num_of_objects+1:end,a)=A(randperm(num_of_objects),a);
        A(num_of_objects+1:end,a)=A(randsample(num_of_objects,num_of_objects,true),a);
    end
    A_d=LIFT_prepare_levels(level,A);
    A=LIFT_create_local_table(k,L,A_d{level}.C,A_d{level}.D);    
    
    clear A_d;
    
    for t=1:T    
        inbag=randsample(2*num_of_objects,2*num_of_objects,true);
        outbag=setdiff(1:2*num_of_objects,unique(inbag));
%        
        A_inbag=A(inbag,:);
        A_outbag=A(outbag,:);
        
        [w g u]=PSVM_build(A_inbag,diag(Y(inbag)),1,speye(length(inbag)));
        
        d=PSVM_classify(A, w, g);
        [ mean(diag(Y(unique(inbag)))*d(unique(inbag)) > 0) mean(diag(Y(outbag))*d(outbag) > 0)]
        d=d(1:num_of_objects); 
%        d=PSVM_classify(A_outbag(outbag<=num_of_objects,:), w, g);
        max_d=max(d);
        min_d=min(d);
        range_d=abs(max_d - min_d);

%        tree=RF_build_randcomb_tree(A_inbag,Y(inbag),5,num_of_classes);
%        S=S+RF_calc_tree_proximities(A(1:num_of_objects,:),tree);
        %update similarity matrix S                

%        if(sum(outbag <= num_of_objects) > 0) 
            outbag=1:num_of_objects;
%            outbag=outbag(outbag<=num_of_objects);
            N=length(outbag);
            for i=1:N
                for j=1:N   
                    if(d(i)*d(j) > 0)
                        S(i,j)=S(i,j) + 1;
                    end
                end 
            end
%        end
        t
    end            
    S=S/T;       