function tree=RF_build_randcomb_tree(A,Y,m,num_of_classes)
    tree_size=rows(A);
    num_of_objects=length(Y);
    L=columns(A);

    %tree stuff
    tree.leaf=sparse(tree_size,1);
    tree.cut=sparse(tree_size,1);
    tree.split=false(tree_size,num_of_objects);
    tree.class_stats=zeros(tree_size,num_of_classes);
    tree.w=sparse(tree_size,L); %best weight vector
       
    node=1;
    classified=0;
    returned=0; %0-nothing, 1 - from left, 2 - from right
    
    A_loc=zeros(num_of_objects,m);
    
    while(true)    
        parent_node=floor(node/2);
        left_node=node*2;
        right_node=node*2+1;
        %
        %Flow-control
        %
        if(returned==1) %returned from left node
            node=right_node; %go to right node
            returned=0;
            continue;            
        else
            if(returned==2) %returned from right node
                if(node==1) %the tree is ready
                    break;
                end
                %go back one level 1
                returned=1+mod(node,2);
                node=parent_node;                
                continue
            end
        end
        
                     
        %
        % Build a new node
        %

        if(node == 1)
            tree.split(node,:)=true(1,num_of_objects);
        end
        node_split=tree.split(node,:);  

        tree.class_stats(node,:)=RF_calc_stats(Y(node_split),num_of_classes);
        
        %is it a leaf?
        if(sum(tree.class_stats(node,:)>0)==1)           
            %increase number of objects being classified
            classified=classified+sum(tree.split(node,:));
            tree.leaf(node)=1;
            
            %go back one level
            returned=1+mod(node,2);
            node=parent_node;            
            continue;
        end
          
        %draw random weights
        rw=2*rand(L,m)-1;
        rw(1,:)=1;
        
        %build local decision table  
        A_loc(node_split,:)=A(node_split,:)*rw;
        [a c f]=RF_find_best_cut(A_loc(node_split,:),Y(node_split),num_of_classes);
        
        tree.w(node,:)=rw(:,a)';
        tree.cut(node)=c;              
                               
        %
        % Update children splits
        %
        %left child (<=)            
        tree.split(left_node,:)=(A_loc(:,a) <= c) & node_split';
        %right child (>)
        tree.split(right_node,:)=(A_loc(:,a) > c) & node_split'; 
        
        %go to left node
        node=left_node;       
    end