function ensemble=PSVM_boost(A,Y,nu,T)
    [num_of_objects num_of_channels N]=size(A)
    
    t=0;
    B=speye(num_of_objects)/num_of_objects;
    while(t<T)                  
         [w g]=PSVM_build(A,diag(Y),nu,B);
            y=diag(Y)*(A*w-g);
            err=sum(B*(y<=0));
            alpha=0.5*log((1+err)/(1-err));
            [t err alpha]
        end
        t=t+1;
    end