function err=PSVM_bootstrap_err(A,Y,T,levels,L,nu)
    %function err=PSVM_bootstrap_err(A,Y,T)
    %A - matrix with training examples organized in rows
    %Y - vector with labels
    %T - number of bootstrap iterations

    num_of_objects=rows(A);
    
    err=zeros(columns(A),1);
%    err=0;
%    levels=1;
%    L=floor(columns(A)/2);
    err2=0;
    for t=1:T
        t
        inbag=randsample(num_of_objects,num_of_objects,true);
        outbag=setdiff(1:num_of_objects,unique(inbag));
        
        A_inbag_d=LIFT_prepare_levels(levels,A(inbag,:));
        A_outbag_d=LIFT_prepare_levels(levels,A(outbag,:));
        
        [W i]=build_local_classifiers_reg(A_inbag_d,diag(Y(inbag)),L,nu);
        [d_in i]=classify_with_local_classifiers_reg(A_inbag_d,levels,W);
        
        r=mean(diag(Y(inbag))*d_in <= 0);
        [rs si]=sort(r);
%        si=si(1:4);
        [w g u]=PSVM_build(d_in(:,si),diag(Y(inbag)),nu,speye(length(inbag)));        
        
        [d i]=classify_with_local_classifiers_reg(A_outbag_d,levels,W);        
           
        err2=err2+mean(Y(outbag).*(d(:,si)*w - g) <= 0);
        
        e=mean(diag(Y(outbag))*d <= 0);
        err=err+e';

        [ min(e) mean(e) max(e); min(err/t) mean(err/t) max(err/t)]
        err2/t
    end
    err=err/T;
    err2=err2/T;
    
    %calc training error   
    [W i]=build_local_classifiers_reg(LIFT_prepare_levels(levels,A),diag(Y),L,nu);
    [d i]=classify_with_local_classifiers_reg(LIFT_prepare_levels(levels,A),levels,W);
    
    r=mean(diag(Y)*d <= 0);
    [rs si]=sort(r);
%    si=si(1:4);
    [w g u]=PSVM_build(d(:,si),diag(Y),nu,speye(rows(d)));
    err2_=mean(Y.*(d(:,si)*w - g) <= 0);
    
    e=mean(diag(Y)*d <= 0);
    [min(e) mean(e) max(e)]
      
    err=0.632*err + 0.368*e';    
    err2=0.632*err2+0.368*err2_