function ensemble=PSVM_build_ava(A,Y,parameters)
    %function ensemble=PSVM_build_ava(A,Y,nu)
    %   builds ensemble of PSVMs for multiclass dataset A
    %   using "All-versus-All" scheme
    
    classes=DATA_classes(Y);    
    ensemble=cell(length(classes)*(length(classes)-1)/2,1);
    t=1;
    for c0=1:length(classes)-1
        for c1=(c0+1):length(classes)   
            ind=find((Y==classes(c0))|(Y==classes(c1)));
            %disp([c0 c1 length(ind)])
            Y_bin=Y(ind);
            Y_bin(Y_bin==classes(c0))=-1;
            Y_bin(Y_bin==classes(c1))=1;

            psvm=PSVM_build(A(ind,:),...
                spdiags(Y_bin,0,length(ind),length(ind)),...
                ones(length(ind),1),parameters);
            ensemble{t}.psvm=psvm;
            ensemble{t}.c0=c0;
            ensemble{t}.c1=c1;
            t=t+1;
        end
    end
