function [error ensemble]=PSVM_multiclass_boosting(A,Y,T,nu)
    ensemble=[];
    error=[];
    classes=unique(Y);
    D=zeros(rows(A),length(classes));
    
    %initialize weights
    for o=1:rows(D)
        for c=1:length(classes)
            D(o,c)= (classes(c)~=Y(o));
        end
    end
    D=D/(rows(A)*(length(classes)-1));
    
    for t=1:T
        %draw coloring        
        positive=randsample(length(classes),floor(length(classes)/2));
        negative=setdiff(1:length(classes),positive);
               
        Y_bin=zeros(size(Y));
        Y_bin(ismember(Y,classes(positive)))=+1;
        Y_bin(ismember(Y,classes(negative)))=-1;                
        
        %calculate U_t and examples' weights
        D2=zeros(rows(A),1);
        D2(Y_bin==1)=D2(Y_bin==1)+sum(D(Y_bin==1,negative)')';
        D2(Y_bin==-1)=D2(Y_bin==-1)+sum(D(Y_bin==-1,positive)')';        

        D2=D2/sum(D2);       
        
        %resample data
        I=randsample(rows(A),rows(A),true,D2);
        A_t=A(I,:);
        Y_t=Y_bin(I);
        
        [w g]=PSVM_build(A_t,spdiags(Y_t,0,rows(A_t),rows(A_t)),nu,speye(rows(A_t)));
        y=A_t*w-g;        
        
        err=0;
        
        for o=1:rows(A_t)
            if(y(o) > 0)
                a=Y_t(o) <= 0;
                for c=1:length(positive)
                    err=err+D(o,positive(c))*(a + 1);
                end
            else
                a=Y_t(o)>0;
                for c=1:length(negative)
                    err=err+D(o,negative(c))*(a + 1);
                end                    
            end
        end

        err=err/2;        
        error=[error; err];
        alpha=0.5*log((1-err)/err);        
        
        %update weights
        for o=1:rows(A_t)
            if (y(o) > 0)
                a=Y_t(o) <= 0;
                for c=1:length(positive)
                    D(o,positive(c))=D(o,positive(c))*exp(alpha*(a + 1));
                end
            else
                a=Y_t(o)>0;
                for c=1:length(negative)
                    D(o,negative(c))=D(o,negative(c))*exp(alpha*(a + 1));
                end  
            end
        end        
        D=D/sum(sum(D));
        
        ensemble=[ensemble; w' g alpha positive'];
    end