function [X Y]=WAVEFORM_generate(N,T)
    X=zeros(3*N,T);
    Y=zeros(3*N,1);
    Y(1:N)=1; Y(N+1:2*N)=2; Y(2*N+1:end)=3;
    h=zeros(3,T);
    for i=1:T
        h(1,i)=max(6-abs(i- 7),0);
        h(2,i)=max(6-abs(i-15),0);
        h(3,i)=max(6-abs(i-11),0);
    end
    
    for o=1:3*N        
        e=randn(1,T);
        u=rand;
        if(Y(o)==1)
            X(o,:)=u*h(1,:)+(1-u)*h(2,:)+e;
        end
        if(Y(o)==2)
            X(o,:)=u*h(1,:)+(1-u)*h(3,:)+e; 
        end
        if(Y(o)==3)
            X(o,:)=u*h(2,:)+(1-u)*h(3,:)+e;
        end
    end