function GABOR_RF_MC_build_tree((m,A,Y,sample,num_of_classes)
    tree_size=2^10;
    [l C N]=size(A);				
    num_of_objects=length(Y);

    %tree stuff
    tree.leaf=sparse(tree_size,1);
    tree.cut=sparse(tree_size,1);
    tree.split=false(tree_size,num_of_objects);
    tree.class_stats=zeros(tree_size,num_of_classes);
    
    %Gabor function parameters
    tree.width=sparse(tree_size,1);
    tree.scale=sparse(tree_size,1);
    tree.phase=sparse(tree_size,1);
    tree.k=sparse(tree_size,1);

    
    A_loc=zeros(num_of_objects,m*floor(log2(N)));
    
    node=1;
    classified=0;
    returned=0; %0-nothing, 1 - from left, 2 - from right
    
    while(true)
        node;
        parent_node=floor(node/2);
        left_node=node*2;
        right_node=node*2+1;
        %
        %Flow-control
        %
        if(returned==1) %returned from left node
            node=right_node; %go to right node
            returned=0;
            continue;            
        else
            if(returned==2) %returned from right node
                if(node==1) %the tree is ready
                    break;
                end
                %go back one level 1
                returned=1+mod(node,2);
                node=parent_node;                
                continue
            end
        end
        
                     
        %
        % Build a new node
        %

        if(node == 1)
            tree.split(node,:)=true(1,num_of_objects);
        end
        node_split=tree.split(node,:);  

        tree.class_stats(node,:)=RF_calc_stats(Y(node_split),num_of_classes);
        
        %is it a leaf?
        if(sum(tree.class_stats(node,:)>0)==1)           
            %increase number of objects being classified
            classified=classified+sum(tree.split(node,:));
            tree.leaf(node)=1;
            
            %go back one level
            returned=1+mod(node,2);
            node=parent_node;            
            continue;
        end
          
        %draw random dictionary of Gabor functions
	[vectors atoms]=GABOR_rand_dict(m,N);
        
        %build local decision table
	A_loc(node_split,:)=A(sample(node_split),:)*vectors;
        
        [a c f]=RF_find_best_cut(A_loc(node_split,:),Y(node_split),num_of_classes);
	tree.width(node)=atoms{a}.width;
	tree.scale(node)=atoms{a}.scale;
	tree.phase(node)=atoms{a}.phase;
        tree.k(node)=atoms{a}.k;
        tree.cut(node)=c;
              
                               
        %
        % Update children splits
        %
        %left child (<=)            
        tree.split(left_node,:)=(A_loc(:,a) <= c) & node_split';
        %right child (>)
        tree.split(right_node,:)=(A_loc(:,a) > c) & node_split'; 
        
        %go to left node
        node=left_node;       
    end