function [y support]=GABOR_RF_classify_tree(A,sample,tree)
    num_of_objects=length(sample);
    y=zeros(num_of_objects,1);
    support=zeros(num_of_objects,1);
    for o=1:num_of_objects
        node=1;
        while(true)
            left_node=2*node;
            right_node=2*node+1;
            %is it a leaf?
            if(tree.leaf(node))
               [support(o) y(o)]=max(tree.class_stats(node,:));
               break
            end

            atom=GABOR_build_atom(tree.k(node),...
				  tree.width(node),...
				  tree.scale(node),...
				  tree.phase(node),...
				  columns(A));

	    d=A(sample(o),:)*atom;
	    	    
            c=tree.cut(node);
            if(d <= c)
                node=left_node;
            else
                node=right_node;
            end
        end
    end