function [error best_cnt ensemble]=LC_multiclass_bagging(A,Y,T,levels,L,nu)
    classes=unique(Y);
    ensemble=cell(T,1);
    error=zeros(T,1);
    best_cnt=zeros(T,1);
    for t=1:T
	fprintf('t=          \r');
        fprintf('t=%d\r',t);
        %draw coloring        
        positive=randsample(length(classes),floor(length(classes)/2));
        negative=setdiff(1:length(classes),positive);
        Y_bin=zeros(size(Y));
        Y_bin(ismember(Y,positive))=+1;
        Y_bin(ismember(Y,negative))=-1;
        
        %resample data
        I_trn=randsample(rows(A),rows(A),true);
        A_trn_t=A(I_trn,:); A_d_trn_t=LIFT_prepare_levels(levels,A_trn_t);
        Y_trn=Y_bin(I_trn);
        [W i]=build_local_classifiers_reg(A_d_trn_t,spdiags(Y_trn,0,rows(A_trn_t),rows(A_trn_t)),L,nu);

	I_tst=randsample(rows(A),rows(A),true);
        A_tst_t=A(I_tst,:);
        A_d_tst_t=LIFT_prepare_levels(levels,A_tst_t);
	    
        [d_tst i]=classify_with_local_classifiers_reg(A_d_tst_t,levels,W);

        err_tst=mean(spdiags(Y_bin(I_tst),0,rows(A_tst_t),rows(A_tst_t))*d_tst(:,(i(1)+1):end) <=0);

                        
        best_all=find(err_tst<=min(err_tst));
	if length(best_all) > 1
          best_one=best_all(floor(rand*length(best_all))+1);
	else
	  best_one=best_all;
	end

        error(t)=err_tst(best_one);
	best_cnt(t)=length(best_all);
        
        ensemble{t}.W=W;
        ensemble{t}.best=best_one;
        ensemble{t}.positive=positive;
        ensemble{t}.err=err_tst(best_one);
        ensemble{t}.weight=1.0;
    end
