function ensemble=LC_multiclass_boosting(A,Y,parameters)
    %function ensemble=LC_multiclass_boosting(A,Y,parameters)
    %
    %
    % For details see "Using Output Codes to Boost Multiclass Learning 
    % Problems" by Robert E. Schapire
    
    levels=parameters.lifting.levels;
    L=parameters.lifting.L; 
    p=parameters.lifting.p;
    
    T=parameters.arcing.T;
    
    classes=DATA_classes(Y);
    ensemble=cell(1,1);
    
    D=zeros(size(A,1),length(classes));
    %initialize weights
    for c=1:length(classes)
        D(Y==c, classes ~= c)=1;
    end
    D=D/(size(A,1)*(length(classes)-1));
    
    A_d=LIFT_prepare_levels(levels, A);
    
    t=1;
    while(t<=T)
        if ~mod(t,floor(T/10))
            fprintf('t=%d\t [%3.2f %%]\n',t,100*t/T);
        end
        
        %compute coloring
        positive=randsample(length(classes), ...
            floor(length(classes)/2))';
        negative=setdiff(1:length(classes),positive);
        Y_bin=zeros(length(Y),1);
        Y_bin(ismember(Y,classes(positive)))=+1;
        Y_bin(ismember(Y,classes(negative)))=-1;
        
        %calculate U_t and examples' weights
        D_t=zeros(size(A,1),1);
        D_t(Y_bin > 0)=sum(D(Y_bin > 0, negative)');
        D_t(Y_bin < 0)=sum(D(Y_bin < 0, positive)');
        D_t=D_t/sum(D_t);   
        
        local_classifiers=LC_build_reg(A_d, ...
            spdiags(Y_bin,0,size(A,1),size(A,1)), ...
            D_t, parameters,1:size(A,1));
        
        %Find best classifier	 
        Y_tst_pred=LC_classify_reg(A_d, local_classifiers, ...
            parameters);

        best=LC_find_best(Y_tst_pred, Y, D_t);
        
        A_loc_tst=LIFT_create_local_table(best.k, ...
            parameters.lifting.L, ...
			A_d{best.level}.C, A_d{best.level}.D);
        
        y=PSVM_classify(A_loc_tst, ...
            local_classifiers{best.level}{best.k});       
       
        %calc weights for selected classifier
        a=[0 0];
        b=[0 0];
        
        
        
        a(1)=sum(D_t( (y > 0) & (Y_bin > 0) ));
        a(2)=sum(D_t( (y < 0) & (Y_bin > 0) ));
        b(1)=sum(D_t( (y < 0) & (Y_bin < 0) ));
        b(2)=sum(D_t( (y > 0) & (Y_bin < 0) ));
        disp([a(1) a(2) ; b(2) b(1); a(1)+b(1) a(2)+b(2)])
        %disp([sum(D_t(Y_bin < 0)) sum(D_t(Y_bin > 0))])

        %disp([min(D_t) mean(D_t) max(D_t)])
        %disp(length(find(D_t > 1e-8))/length(D_t))
        
        if ((a(2) < 1e-16) && (b(2) < 1e-16))
            break
            D=zeros(size(A,1),length(classes));
            for c=1:length(classes)
                D(Y==c, classes ~= c)=1;
            end
            D=D/(size(A,1)*(length(classes)-1));
        else                    
            if(a(2) > 0 && b(2) > 0)
                a=0.5*log(a(1)/a(2));
                b=0.5*log(b(1)/b(2));
            else                
                a=0.5*log((a(1)+b(1))/(a(2)+b(2)));
                b=a;
            end
        
            %update weights
            g=zeros(size(A,1),1);
            g(y>0)=a;
            g(y<0)=-b;
        
            D(Y_bin > 0, negative)=...
                D(Y_bin > 0, negative).* ...
                exp(g(Y_bin > 0)*ones(1,length(negative)));
        
            D(Y_bin < 0, positive)=...
                D(Y_bin < 0, positive).*...
                exp(g(Y_bin < 0)*ones(1,length(positive)));
            D=D/sum(sum(D));
         
            ensemble{t}.base=best;
            ensemble{t}.psvm=local_classifiers{best.level}{best.k};
            ensemble{t}.positive=positive;            
            ensemble{t}.weight=[a b];
            
            t=t+1;
        end
    end