function [y support]=RF_classify_tree(L,A_d,sample,tree)
    num_of_objects=length(sample);
    y=zeros(num_of_objects,1);
    support=zeros(num_of_objects,1);
    for o=1:num_of_objects
        node=1;
        while(true)
            left_node=2*node;
            right_node=2*node+1;
            %is it a leaf?
            if(tree.leaf(node))
               [support(o) y(o)]=max(tree.class_stats(node,:));
               break
            end
        
            w=tree.w(node,:)';
            level=tree.level(node);
            k=tree.k(node);
            c=tree.cut(node);       
            
            d=LIFT_predict(w,k,L,A_d{level}.C(sample(o),:),A_d{level}.D(sample(o),:));
        
            if(d <= c)
                node=left_node;
            else
                node=right_node;
            end
        end
    end