function [attr cut fit]=RF_find_best_cut(A,Y,num_of_classes)
%
%function [attr cut]=RF_find_best_cut(A,Y,num_of_classes)
%
    num_of_attrs=columns(A);
    num_of_objects=length(Y);
    
    best_a=1;
    best_cut=min(A(:,1))-0.5;
    best_fit=0;
        
    for a=1:num_of_attrs
        [s_a s_i]=sort(A(:,a));                        
        %first all examples are on the right side of the cut
        b_c=s_a(1)-0.5;
        L_stats=RF_calc_stats(Y(A(:,a)<=b_c),num_of_classes);
        R_stats=RF_calc_stats(Y(A(:,a)>b_c),num_of_classes);
        b_f=RF_calc_cut_fit(L_stats,R_stats);

        %search for best cut
        for o=2:num_of_objects
            c=0.5*(s_a(o)+s_a(o-1));
            %update statistics
            o_y=Y(s_i(o-1));
            L_stats(o_y)=L_stats(o_y)+1;
            R_stats(o_y)=R_stats(o_y)-1;       
            
            f=RF_calc_cut_fit(L_stats,R_stats);
            if(f > b_f)
                b_c=c;
                b_f=f;
            end
        end
        
        if(b_f > best_fit)
            best_a=a;
            best_cut=b_c;
            best_fit=b_f;
        end
    end
        
    attr=best_a;
    cut=best_cut;
    fit=best_fit;
    