function [P S]=do_perm_test(A,L,levels,nu,num_of_tests,f)

  P=zeros(num_of_tests,columns(A));

  Y=PSVM_D(f,rows(A)-f); 

  A2=A;
  for p=1:num_of_tests
    [W i]=build_local_classifiers_reg(LIFT_prepare_levels(levels,A2),Y,L,nu);
    [d i]=classify_with_local_classifiers_reg(LIFT_prepare_levels(levels,A2),levels,W);
    P(p,:)=mean(Y*d > 0);
    A2=A(randperm(rows(A)),:);
    if(~mod(p,200))
        fprintf('      Permutation %d',p);
    end
  end

  S=zeros(columns(P),1);
  for c=1:columns(P)
    S(c)=mean(P(1,c) > P(2:end,c));
  end
