function [w g u]=LPSVM_build(A,D,nu,B)
  p=rows(B)-1;
  [m n]=size(A);
  e=ones(m,1);
  C=chol(B*B');
  ABC=(C'\B*A(:,2:end)')'; 
  b=D*A(:,1)+e - D*A(:,2:end)*B'*(C\(C'\speye(p+1,1)));
  H1=D*[A(:,2:end) e ABC];
  H2=D*[A(:,2:end) e -ABC];
  u=nu*(b - H1*((speye(columns(H2))/nu + H2'*H1)\(H2'*b)));
  s=D*u;
  w=(speye(n-1)- B'*(C\(C'\B)))*(A(:,2:end)'*s) + B'*(C\(C'\speye(p+1,1)));
  g=-sum(s);
