function error=PSVM_CVK_ava(A,Y,K,parameters)
    folds=crossvalind('KFold',Y,K);
    
    error=zeros(K,2);
    for k=1:K
        disp('k'); disp(k)
        
        test=find(folds==k); train=find(folds ~= k);
        A_trn=A(train,:);
        A_tst=A(test,:);
        
        Y_trn=Y(train);
        Y_tst=Y(test);
        
        ensemble=PSVM_build_ava(A_trn,Y_trn,parameters);
        Y_trn_pred=PSVM_classify_ava(ensemble,A_trn,sort(unique(Y_trn)));
        Y_tst_pred=PSVM_classify_ava(ensemble,A_tst,sort(unique(Y_trn)));
        
        error(k,1)=mean(Y_trn_pred ~= Y_trn);
        error(k,2)=mean(Y_tst_pred ~= Y_tst);
        disp([error(k,1) error(k,2)]);
    end