function ensemble=PSVM_bagg_channels(A,Y,nu,T)
    [num_of_objects num_of_channels N]=size(A)
    
    t=1;
    B=speye(num_of_objects);
    ensemble=zeros(T,N+2);
    while(t<=T)        
        best_err=1.0;
        best_channel=-1;
        best_w=zeros(1,N);
        best_g=0;
        inbag=randsample(num_of_objects,num_of_objects,true);
        outbag=setdiff(1:num_of_objects,inbag);
        for c=1:num_of_channels
            A_c=squeeze(A(:,c,:));
            [w g]=PSVM_build(A_c(inbag,:),diag(Y(inbag)),nu,B);
            y=diag(Y(outbag))*(A_c(outbag,:)*w-g);
            err=mean((y<=0));
            if(err < best_err)
                best_err=err;
                best_channel=c;
                best_w=w;
                best_g=g;
            end
            [c err]
        end
        alpha=0.5*log((1+err)/(1-err));
        [t best_channel best_err alpha]
        
        ensemble(t,1:N)=best_w;
        ensemble(t,end-1)=best_g;
        ensemble(t,end)=alpha;
        
        t=t+1;
    end