function [E]=calcCVKError(K,X,Y,parameters)
    E=zeros(K,2);
    folds=crossvalind('KFold', Y, K);
    for k=1:K
    	disp(k)
	i_train=folds ~= k;
	i_test=folds == k;
        
        Xtrain=X(i_train,:);
        Xtest=X(i_test,:);
        Ytrain=Y(i_train);
        Ytest=Y(i_test,:);

        psvm_ensemble=PSVM_build_ava(Xtrain,Ytrain,parameters);

        Ytest_pred=PSVM_classify_ava(psvm_ensemble, Xtest, DATA_classes(Y));
        Ytrain_pred=PSVM_classify_ava(psvm_ensemble, Xtrain, DATA_classes(Y));
        E(k,1)=mean(Ytest_pred ~= Ytest);
        E(k,2)=mean(Ytrain_pred ~= Ytrain);   
	disp([E(k,1) E(k,2)])
    end      
%    Eave=mean(E);
