function [votes Y_pred]=PSVM_multiclass_classify(ensemble,A,classes)
    T=rows(ensemble);
    
    votes=zeros(rows(A),length(classes));   
    for t=1:T
        positive=ensemble(t,end-floor(length(classes)/2)+1:end);
        negative=setdiff(classes,positive);
        
        %classify
        w=ensemble(t,1:columns(A))';
        g=ensemble(t,columns(A)+1);
        y=A*w-g;        
        
        votes(y>0,positive)=votes(y>0,positive)+ensemble(t,columns(A)+2);
        votes(y<0,negative)=votes(y<0,negative)+ensemble(t,columns(A)+2);
    end
    
    [s i]=max(votes');    
    Y_pred=classes(i');