function [error forest]=GABOR_RF_build_forest(m,T,A,Y,num_of_classes)
    num_of_objects=length(Y);
    forest.trees=cell(T,1);
    forest.num_of_classes=num_of_classes;    
    votes=zeros(num_of_objects,T);
    error=zeros(T,1);

    for t=1:T   
        inbag=randsample(num_of_objects,num_of_objects,true);

%	[A_t Y_t]=DATA_replicate_randomshift(A(inbag,:),Y(inbag),10,10);

%        forest.trees{t}=GABOR_RF_build_tree(m,A_t,Y_t,1:length(Y_t),num_of_classes);
        forest.trees{t}=GABOR_RF_build_tree(m,A,Y(inbag),inbag,num_of_classes);

        outbag=setdiff(1:num_of_objects,unique(inbag));

        y=GABOR_RF_classify_tree(A,outbag,forest.trees{t});
        votes(outbag,t)=y;
        error(t)=sum(RF_vote_predictions(votes(:,1:t),num_of_classes) ~= Y);
	if ~mod(t,10)
            [t (error(t)/num_of_objects)]
          end
      end    