function dict=GABOR_build_dictionary(N,T)
  dict=zeros(T,N);

  max_s=log2(N);

  x=linspace(0,1,N);

  for a=1:T
    t=floor(rand*N)+1; %time position
    s=2^floor(rand*log2(N)) %window width
    
    w=floor(rand*s/2)+1
    fi=rand*pi;

    
    x=linspace(-pi,pi,s);

    a_tmp=(exp((-pi*x.^2)/s).*sin(w*x+fi))';

    a_tmp=[a_tmp; zeros(N-s,1)];
    a_tmp=a_tmp/norm(a_tmp);

    dict(a,:)=circshift(a_tmp,s-t)';
  end
  