function ensemble=LCMC_multiclass_arcing(A,Y,parameters)
%function ensemble=LCMC_multiclass_arcing(A,Y,parameters)

    %C - number of channels
    %l - number of training examples
    %N - number of samples

    levels=parameters.lifting.levels;
    L=parameters.lifting.L;
    p=parameters.lifting.p;
   
    h=parameters.arcing.h;
    T=parameters.arcing.T;
    
    classes=DATA_classes(Y);
    ensemble=cell(1,1);
   
    [l C N]=size(A);
    
    if parameters.arcing.nC < 0
        nC=C;
    else
        nC=parameters.arcing.nC;
    end
    

   
    %Weights
    % M(i,j) equals number of times i-th
    % example was wrongly classified as
    % belonging to j-th class
    M=zeros(l,length(classes));
    D=zeros(l,length(classes));
   

    error=zeros(T,1);
    best_k=zeros(T,1);
    best_cnt=zeros(T,1);

    A_trn_t=zeros(l,N);

    t=1;
    while t<=T
        if ~mod(t,floor(T/10))
            fprintf('t=%d\t [%3.2f %%]\n',t,100*t/T);
        end
        
        %Calculate weights
        D=1+M.^h;
        D=D/sum(sum(D));
        
        %draw coloring        
        positive=randsample(length(classes),floor(length(classes)/2));
        positive=positive';
        negative=setdiff(1:length(classes),positive);
        
        Y_bin=zeros(length(Y),1);
        Y_bin(ismember(Y,classes(positive)))=+1;
        Y_bin(ismember(Y,classes(negative)))=-1;        
        
        D_t=zeros(l,1);
        for i=1:l
            if(ismember(Y(i),classes(positive)))
                D_t(i)=sum(D(i,negative));
            else
                D_t(i)=sum(D(i,positive));
            end
        end
        D_t=D_t/sum(D_t);

        %resample data
        I_trn=randsample(l,l,true,D_t);
%        I_trn=randsample(size(A,1),size(A,1),true);
        %A_trn_t=A(I_trn,:); 
        %A_d_trn_t=LIFT_prepare_levels(levels,A_trn_t);
        Y_trn=Y_bin(I_trn);
       
        best_all.channel=-1;
        best_all.level=-1;
        best_all.k=-1;
        best_all.err=2.0;
        best_psvm=cell(1,1);
        channels=randperm(C);
        for channel=1:nC
           if nC < C
               c=floor(rand*C)+1;
           else
               c=channels(channel);
           end

           %resample data
           A_trn_t=squeeze(A(I_trn,c,:)); 		
           A_d_trn_t=LIFT_prepare_levels(levels,A_trn_t);
	   
           local_classifiers=LC_build_reg(A_d_trn_t, ...
            spdiags(Y_trn,0,size(A_trn_t,1),size(A_trn_t,1)), ...
            ones(length(Y_trn),1), parameters,1:length(Y_trn));
           
            %Find best k-th classifier

            %A_tst_t=squeeze(A(:,c,:));
            %A_tst_t=A_trn_t;
            %Y_tst=Y_bin;
            Y_tst=Y_trn;
            
            %A_d_tst_t=LIFT_prepare_levels(levels,A_tst_t);            
            A_d_tst_t=A_d_trn_t;
	  
            Y_tst_pred=LC_classify_reg(A_d_tst_t, local_classifiers, ...
                parameters);
            
            %best=LC_find_best(Y_tst_pred, Y_tst, D_t);
            best=LC_find_best(Y_tst_pred, Y_tst);
            
            if best.err < best_all.err
                best_all=best;
                best_all.channel=c;
                best_psvm=local_classifiers{best.level}{best.k};
            end
        end
        if best_all.err < 0.5
            A_d=LIFT_prepare_levels(levels,squeeze(...
                A(:,best_all.channel,:)));
            A_loc_tst=LIFT_create_local_table(best.k, ...
                parameters.lifting.L, ...
                A_d{best.level}.C, A_d{best.level}.D);
            y=PSVM_classify(A_loc_tst, best_psvm);
            
            %Update weights
            for i=1:length(Y_bin)
                if (y(i)*Y_bin(i) <= 0)
                    if (y(i) > 0)
                        M(i,positive)=M(i,positive)+1;
                    else
                        M(i,negative)=M(i,negative)+1;
                    end
                end
            end
            
            %disp([1-best_all.err best_all.err])
            
            ensemble{t}.base=best_all;
            ensemble{t}.psvm=best_psvm;
            ensemble{t}.positive=positive;
            ensemble{t}.weight=1;
            
            t=t+1;
        end
    end
