function [error best_cnt ensemble]=LC_multiclass_arcing(A,Y,T,h,levels,L,nu)
  %function [error best_cnt ensemble]=LC_multiclass_arcing(A,Y,T,h,levels,L,nu)

  [l C N]=size(A);
  %l - number of objects
  %M - number of channels
  %N - length of signals

  classes=unique(Y);
  ensemble=cell(T,1);

  %Weights
  % M(i,j) equals number of times i-th
  % example was wrongly classified as
  % belonging to j-th class
  M=zeros(rows(A),length(classes));
  D=zeros(rows(A),length(classes));
    

  error=zeros(T,1);
  best_cnt=zeros(T,1);

  for t=1:T
				%draw coloring        
    positive=randsample(length(classes),floor(length(classes)/2));
    negative=setdiff(1:length(classes),positive);
    Y_bin=zeros(size(Y));
    Y_bin(ismember(Y,positive))=+1;
    Y_bin(ismember(Y,negative))=-1;

				%Calculate weights
    D=1+M.^h;
    D=D/sum(sum(D));	

    D_t=zeros(rows(A),1);
    for i=1:rows(A)
      if(ismember(Y(i),positive))
	D_t(i)=sum(D(i,negative));
      else
	D_t(i)=sum(D(i,positive));
      end
    end
    D_t=D_t/sum(D_t);
        
				%resample data
    I_trn=randsample(l,l,true,D_t);

				%Iterate through all channels
    errors=[];
    for c=1:C
      A_trn_t=squeeze(A(I_trn,c,:)); A_d_trn_t=LIFT_prepare_levels(levels,A_trn_t);
      Y_trn=Y_bin(I_trn);
      [W i]=build_local_classifiers_reg(A_d_trn_t,spdiags(Y_trn,0,rows(A_trn_t),rows(A_trn_t)),L,nu);


      Y_tst=Y_trn;
      
      [d_tst i]=classify_with_local_classifiers_reg(A_d_trn_t,levels,W);
      d_tst=d_tst(:,(i(1)+1):end);
      err_tst=mean(spdiags(Y_tst,0,rows(A_tst_t),rows(A_tst_t))*d_tst <=0);
      
      errors=[errors; err_tst];
    end

    
    [best_i best_j]=find(errors<=min(errors));
    best_one=best_all(floor(rand*length(best_i))+1);

    best_channel=best_i(best_one);
    best_k=best_j(best_one);

    best_cnt(t)=length(best_j);

    error(t)=errors(best_channel,best_k);

    %Classify training set with best classifier
    [d i]=classify_with_local_classifiers_reg(LIFT_prepare_levels(levels,squeeze(A,best_channel,:)),levels,W);
    d=d(:,(i(1)+1):end); 
    y=d(:,best_k);

				%Update weights
    for i=1:rows(A)
      if y(i)*Y_bin(i) < 0
	if y(i) > 0
	  M(i,positive)=M(i,positive)+1;
	else
	  M(i,negative)=M(i,negative)+1;
	end
      end
    end

    ensemble{t}.W=W;
    ensemble{t}.channel=best_channel;
    ensemble{t}.best=best_k;	
    ensemble{t}.positive=positive;
    ensemble{t}.err=err_tst;
    ensemble{t}.weight=1.0;
  end