function ensemble=LC_multiclass_arcing(A,Y,parameters)
%function ensemble=LC_multiclass_arcing(A,Y,parameters)

    levels=parameters.lifting.levels;
    L=parameters.lifting.L; 
    p=parameters.lifting.p;
    
    h=parameters.arcing.h;
    T=parameters.arcing.T;  
    
    classes=DATA_classes(Y);
    ensemble=cell(1,1);


    %Weights
    % M(i,j) equals number of times i-th
    % example was wrongly classified as
    % belonging to j-th class
    M=zeros(size(A,1),length(classes));
    D=zeros(size(A,1),length(classes));   

    A_d=LIFT_prepare_levels(levels, A);
    
    t=1;
    while t<=T
        if ~mod(t,floor(T/10))
            fprintf('t=%d\t [%3.2f %%]\n',t,100*t/T);
        end
        
        %Calculate weights
        D=1+M.^h;
        D=D/sum(sum(D));
        
        %draw coloring
        positive=randsample(length(classes),floor(length(classes)/2));
        positive=positive';
        negative=setdiff(1:length(classes),positive);  
        
        Y_bin=zeros(length(Y),1);
        Y_bin(ismember(Y,classes(positive)))=+1;
        Y_bin(ismember(Y,classes(negative)))=-1;       

        D_t=zeros(size(A,1),1);
        for i=1:size(A,1)
            if(ismember(Y(i),classes(positive)))
                D_t(i)=sum(D(i,negative));
            else
                D_t(i)=sum(D(i,positive));
            end
        end
        D_t=D_t/sum(D_t);   
        
        %resample data
        I_trn=randsample(size(A,1),size(A,1),true,D_t);
%        I_trn=randsample(size(A,1),size(A,1),true);
        A_trn_t=A(I_trn,:); 
        A_d_trn_t=LIFT_prepare_levels(levels,A_trn_t);
        Y_trn=Y_bin(I_trn);

        local_classifiers=LC_build_reg(A_d_trn_t, ...
            spdiags(Y_trn,0,size(A_trn_t,1),size(A_trn_t,1)), ...
            ones(length(Y_trn),1), parameters,1:length(Y_trn));


        %Find best classifier
        %I_tst=randsample(size(A,1),size(A,1),true,D_t);
        A_d_tst_t=A_d_trn_t;
        Y_tst=Y_trn;
        %A_d_tst_t=LIFT_prepare_levels(levels,A_tst_t);
        %Y_tst=Y_bin(I_tst);
        %A_d_tst_t=A_d;
        %Y_tst=Y_bin;
	  
        Y_tst_pred=LC_classify_reg(A_d_tst_t, local_classifiers, ...
            parameters);

        best=LC_find_best(Y_tst_pred, Y_tst, D_t);
        %best=LC_find_best(Y_tst_pred, Y_tst);        
        
        if best.err < 0.5        
            A_loc_tst=LIFT_create_local_table(best.k, ...
                parameters.lifting.L, ...
                A_d{best.level}.C, A_d{best.level}.D);            
            y=PSVM_classify(A_loc_tst, ...
                local_classifiers{best.level}{best.k});

            %Update weights
            for i=1:length(Y_bin)
                if (y(i)*Y_bin(i) <= 0)
                    if (y(i) > 0)
                        M(i,positive)=M(i,positive)+1;
                    else
                        M(i,negative)=M(i,negative)+1;
                    end
                end
            end
            
            %disp([1-best.err best.err])
	    %disp(local_classifiers{best.level}{best.k}.press)
            
            ensemble{t}.base=best;
            ensemble{t}.psvm=local_classifiers{best.level}{best.k};
            ensemble{t}.positive=positive;
            ensemble{t}.weight=1;
                
            t=t+1;
        end
    end
