function [error ensemble]=PSVM_multiclass_bagging(A,Y,T,nu)
    ensemble=[];
    error=[];
    classes=unique(Y);
    for t=1:T
        %draw coloring        
        positive=randsample(length(classes),floor(length(classes)/2));
        negative=setdiff(1:length(classes),positive);
        
        Y_bin=zeros(size(Y));
        Y_bin(ismember(Y,positive))=+1;
        Y_bin(ismember(Y,negative))=-1;
        
        %resample data
        I=randsample(rows(A),rows(A),true);
        A_t=A(I,:);
        Y_t=Y_bin(I);
        
        [w g]=PSVM_build(A_t,spdiags(Y_t,0,rows(A_t),rows(A_t)),nu,speye(rows(A)));
        err=mean(Y_t.*(A_t*w -g) <=0);
        error=[error; mean(Y_t.*(A_t*w -g) <=0)];
        ensemble=[ensemble; w' g 1.0 positive'];
    end